<?php

namespace ChurchCRM\Map;

use ChurchCRM\RecordProperty;
use ChurchCRM\RecordPropertyQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the 'record2property_r2p' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class RecordPropertyTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'ChurchCRM.Map.RecordPropertyTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'record2property_r2p';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\ChurchCRM\\RecordProperty';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'ChurchCRM.RecordProperty';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 3;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 3;

    /**
     * the column name for the r2p_pro_ID field
     */
    const COL_R2P_PRO_ID = 'record2property_r2p.r2p_pro_ID';

    /**
     * the column name for the r2p_record_ID field
     */
    const COL_R2P_RECORD_ID = 'record2property_r2p.r2p_record_ID';

    /**
     * the column name for the r2p_Value field
     */
    const COL_R2P_VALUE = 'record2property_r2p.r2p_Value';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('PropertyId', 'RecordId', 'PropertyValue', ),
        self::TYPE_CAMELNAME     => array('propertyId', 'recordId', 'propertyValue', ),
        self::TYPE_COLNAME       => array(RecordPropertyTableMap::COL_R2P_PRO_ID, RecordPropertyTableMap::COL_R2P_RECORD_ID, RecordPropertyTableMap::COL_R2P_VALUE, ),
        self::TYPE_FIELDNAME     => array('r2p_pro_ID', 'r2p_record_ID', 'r2p_Value', ),
        self::TYPE_NUM           => array(0, 1, 2, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('PropertyId' => 0, 'RecordId' => 1, 'PropertyValue' => 2, ),
        self::TYPE_CAMELNAME     => array('propertyId' => 0, 'recordId' => 1, 'propertyValue' => 2, ),
        self::TYPE_COLNAME       => array(RecordPropertyTableMap::COL_R2P_PRO_ID => 0, RecordPropertyTableMap::COL_R2P_RECORD_ID => 1, RecordPropertyTableMap::COL_R2P_VALUE => 2, ),
        self::TYPE_FIELDNAME     => array('r2p_pro_ID' => 0, 'r2p_record_ID' => 1, 'r2p_Value' => 2, ),
        self::TYPE_NUM           => array(0, 1, 2, )
    );

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var string[]
     */
    protected $normalizedColumnNameMap = [

        'PropertyId' => 'R2P_PRO_ID',
        'RecordProperty.PropertyId' => 'R2P_PRO_ID',
        'propertyId' => 'R2P_PRO_ID',
        'recordProperty.propertyId' => 'R2P_PRO_ID',
        'RecordPropertyTableMap::COL_R2P_PRO_ID' => 'R2P_PRO_ID',
        'COL_R2P_PRO_ID' => 'R2P_PRO_ID',
        'r2p_pro_ID' => 'R2P_PRO_ID',
        'record2property_r2p.r2p_pro_ID' => 'R2P_PRO_ID',
        'RecordId' => 'R2P_RECORD_ID',
        'RecordProperty.RecordId' => 'R2P_RECORD_ID',
        'recordId' => 'R2P_RECORD_ID',
        'recordProperty.recordId' => 'R2P_RECORD_ID',
        'RecordPropertyTableMap::COL_R2P_RECORD_ID' => 'R2P_RECORD_ID',
        'COL_R2P_RECORD_ID' => 'R2P_RECORD_ID',
        'r2p_record_ID' => 'R2P_RECORD_ID',
        'record2property_r2p.r2p_record_ID' => 'R2P_RECORD_ID',
        'PropertyValue' => 'R2P_VALUE',
        'RecordProperty.PropertyValue' => 'R2P_VALUE',
        'propertyValue' => 'R2P_VALUE',
        'recordProperty.propertyValue' => 'R2P_VALUE',
        'RecordPropertyTableMap::COL_R2P_VALUE' => 'R2P_VALUE',
        'COL_R2P_VALUE' => 'R2P_VALUE',
        'r2p_Value' => 'R2P_VALUE',
        'record2property_r2p.r2p_Value' => 'R2P_VALUE',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('record2property_r2p');
        $this->setPhpName('RecordProperty');
        $this->setIdentifierQuoting(false);
        $this->setClassName('\\ChurchCRM\\RecordProperty');
        $this->setPackage('ChurchCRM');
        $this->setUseIdGenerator(false);
        $this->setIsCrossRef(true);
        // columns
        $this->addForeignPrimaryKey('r2p_pro_ID', 'PropertyId', 'SMALLINT' , 'property_pro', 'pro_ID', true, 8, null);
        $this->addPrimaryKey('r2p_record_ID', 'RecordId', 'SMALLINT', true, 8, null);
        $this->addColumn('r2p_Value', 'PropertyValue', 'LONGVARCHAR', true, null, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Property', '\\ChurchCRM\\Property', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':r2p_pro_ID',
    1 => ':pro_ID',
  ),
), null, null, null, false);
    } // buildRelations()

    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database. In some cases you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by find*()
     * and findPk*() calls.
     *
     * @param \ChurchCRM\RecordProperty $obj A \ChurchCRM\RecordProperty object.
     * @param string $key             (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (null === $key) {
                $key = serialize([(null === $obj->getPropertyId() || is_scalar($obj->getPropertyId()) || is_callable([$obj->getPropertyId(), '__toString']) ? (string) $obj->getPropertyId() : $obj->getPropertyId()), (null === $obj->getRecordId() || is_scalar($obj->getRecordId()) || is_callable([$obj->getRecordId(), '__toString']) ? (string) $obj->getRecordId() : $obj->getRecordId())]);
            } // if key === null
            self::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param mixed $value A \ChurchCRM\RecordProperty object or a primary key value.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && null !== $value) {
            if (is_object($value) && $value instanceof \ChurchCRM\RecordProperty) {
                $key = serialize([(null === $value->getPropertyId() || is_scalar($value->getPropertyId()) || is_callable([$value->getPropertyId(), '__toString']) ? (string) $value->getPropertyId() : $value->getPropertyId()), (null === $value->getRecordId() || is_scalar($value->getRecordId()) || is_callable([$value->getRecordId(), '__toString']) ? (string) $value->getRecordId() : $value->getRecordId())]);

            } elseif (is_array($value) && count($value) === 2) {
                // assume we've been passed a primary key";
                $key = serialize([(null === $value[0] || is_scalar($value[0]) || is_callable([$value[0], '__toString']) ? (string) $value[0] : $value[0]), (null === $value[1] || is_scalar($value[1]) || is_callable([$value[1], '__toString']) ? (string) $value[1] : $value[1])]);
            } elseif ($value instanceof Criteria) {
                self::$instances = [];

                return;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or \ChurchCRM\RecordProperty object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value, true)));
                throw $e;
            }

            unset(self::$instances[$key]);
        }
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('PropertyId', TableMap::TYPE_PHPNAME, $indexType)] === null && $row[TableMap::TYPE_NUM == $indexType ? 1 + $offset : static::translateFieldName('RecordId', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return serialize([(null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('PropertyId', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('PropertyId', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('PropertyId', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('PropertyId', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('PropertyId', TableMap::TYPE_PHPNAME, $indexType)]), (null === $row[TableMap::TYPE_NUM == $indexType ? 1 + $offset : static::translateFieldName('RecordId', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 1 + $offset : static::translateFieldName('RecordId', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 1 + $offset : static::translateFieldName('RecordId', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 1 + $offset : static::translateFieldName('RecordId', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 1 + $offset : static::translateFieldName('RecordId', TableMap::TYPE_PHPNAME, $indexType)])]);
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
            $pks = [];

        $pks[] = (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('PropertyId', TableMap::TYPE_PHPNAME, $indexType)
        ];
        $pks[] = (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 1 + $offset
                : self::translateFieldName('RecordId', TableMap::TYPE_PHPNAME, $indexType)
        ];

        return $pks;
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? RecordPropertyTableMap::CLASS_DEFAULT : RecordPropertyTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (RecordProperty object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = RecordPropertyTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = RecordPropertyTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + RecordPropertyTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = RecordPropertyTableMap::OM_CLASS;
            /** @var RecordProperty $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            RecordPropertyTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = RecordPropertyTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = RecordPropertyTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var RecordProperty $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                RecordPropertyTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(RecordPropertyTableMap::COL_R2P_PRO_ID);
            $criteria->addSelectColumn(RecordPropertyTableMap::COL_R2P_RECORD_ID);
            $criteria->addSelectColumn(RecordPropertyTableMap::COL_R2P_VALUE);
        } else {
            $criteria->addSelectColumn($alias . '.r2p_pro_ID');
            $criteria->addSelectColumn($alias . '.r2p_record_ID');
            $criteria->addSelectColumn($alias . '.r2p_Value');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria object containing the columns to remove.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function removeSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(RecordPropertyTableMap::COL_R2P_PRO_ID);
            $criteria->removeSelectColumn(RecordPropertyTableMap::COL_R2P_RECORD_ID);
            $criteria->removeSelectColumn(RecordPropertyTableMap::COL_R2P_VALUE);
        } else {
            $criteria->removeSelectColumn($alias . '.r2p_pro_ID');
            $criteria->removeSelectColumn($alias . '.r2p_record_ID');
            $criteria->removeSelectColumn($alias . '.r2p_Value');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(RecordPropertyTableMap::DATABASE_NAME)->getTable(RecordPropertyTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(RecordPropertyTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(RecordPropertyTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new RecordPropertyTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a RecordProperty or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or RecordProperty object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(RecordPropertyTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \ChurchCRM\RecordProperty) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(RecordPropertyTableMap::DATABASE_NAME);
            // primary key is composite; we therefore, expect
            // the primary key passed to be an array of pkey values
            if (count($values) == count($values, COUNT_RECURSIVE)) {
                // array is not multi-dimensional
                $values = array($values);
            }
            foreach ($values as $value) {
                $criterion = $criteria->getNewCriterion(RecordPropertyTableMap::COL_R2P_PRO_ID, $value[0]);
                $criterion->addAnd($criteria->getNewCriterion(RecordPropertyTableMap::COL_R2P_RECORD_ID, $value[1]));
                $criteria->addOr($criterion);
            }
        }

        $query = RecordPropertyQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            RecordPropertyTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                RecordPropertyTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the record2property_r2p table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return RecordPropertyQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a RecordProperty or Criteria object.
     *
     * @param mixed               $criteria Criteria or RecordProperty object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(RecordPropertyTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from RecordProperty object
        }


        // Set the correct dbName
        $query = RecordPropertyQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // RecordPropertyTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
RecordPropertyTableMap::buildTableMap();
